# -*- coding: utf-8 -*-
#///////////////////////////////////////////////////////
# 
#///////////////////////////////////////////////////////


# Importation des bibliothèques nécessaires
from matplotlib import pyplot as plt
from math import *

# ------------------- Variables globales --------------------
m=3000      # Masse de la nacelle (en kg)
g=9.8       # Champ de pesanteur terrestre (en m/s^2)
hA=90       # Hauteur initiale (en m)
vA=0        # Vitesse initiale (en m / s)
EppA=m*g*hA # Energie potentielle de pesanteur initiale (en J)

# ------------- Initialisation des listes vides --------------
H=[]
t=[]
vB=[]
EcB=[]
EppB=[]
EmB=[]

# ---------------- Construction des listes -----------------
# La méthode .append ajoute des éléments à une liste
# Dans la boucle for, la variable h varie de 0 à 90 par pas de 10

for h in range (0,90,10):
    H.append(h)
    t.append(sqrt(2*h/g))
    vB.append(sqrt(vA**2+2*g*h))
    EcB.append(0.5*m*(sqrt(vA**2+2*g*h))**2)
    EppB.append(EppA-m*g*h)
    EmB.append(0.5*m*(sqrt(vA**2+2*g*h))**2 + EppA-m*g*h)

# ----------------------- Graphiques -----------------------
plt.plot(t,EppB,"bo--",label="EppB")
plt.plot(t,EcB,"ro--",label="EcB")
plt.plot(t,EmB,"go--",label="EmB")
plt.title("Evolution temporelle des énergies de la nacelle")
plt.xlabel('Durée de la chute (en s)')
plt.ylabel('Energies (en J)')
plt.grid()
plt.legend()
plt.show()

